<?php
require_once 'config.php';

if (isLoggedIn()) {
    redirect('index');
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username']);
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $referral_code = sanitize($_POST['referral_code']);

    if (empty($username) || empty($email) || empty($password)) {
        $message = 'Please fill all required fields';
    } elseif ($password !== $confirm_password) {
        $message = 'Passwords do not match';
    } elseif (strlen($password) < 8) {
        $message = 'Password must be at least 8 characters';
    } else {
        $db = getDB();

        // Check if email or username exists
        $stmt = $db->prepare('SELECT id FROM users WHERE email = ? OR username = ?');
        $stmt->execute([$email, $username]);
        if ($stmt->fetch()) {
            $message = 'Email or username already exists';
        } else {
            // Handle referral
            $referrer_id = null;
            if (!empty($referral_code)) {
                $stmt = $db->prepare('SELECT id FROM users WHERE referral_code = ?');
                $stmt->execute([$referral_code]);
                $referrer = $stmt->fetch();
                if ($referrer) {
                    $referrer_id = $referrer['id'];
                }
            }

            // Create user
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $referral_code = generateReferralCode();

            $stmt = $db->prepare('INSERT INTO users (username, email, password, referral_code, referrer_id) VALUES (?, ?, ?, ?, ?)');
            if ($stmt->execute([$username, $email, $hashed_password, $referral_code, $referrer_id])) {
                $user_id = $db->lastInsertId();
                $_SESSION['user_id'] = $user_id;

                // Send welcome email
                $subject = 'Welcome to ' . SITE_NAME;
                $message_body = "Welcome $username! Your account has been created successfully.";
                sendEmail($email, $subject, $message_body);

                redirect('index');
            } else {
                $message = 'Registration failed. Please try again.';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body class="login-page">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card mt-5">
                    <div class="card-header text-center">
                        <h3>Register for <?php echo SITE_NAME; ?></h3>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-danger"><?php echo $message; ?></div>
                        <?php endif; ?>
                        <form method="post">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="username">Username</label>
                                        <input type="text" class="form-control" id="username" name="username" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="confirm_password">Confirm Password</label>
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="referral_code">Referral Code (Optional)</label>
                                <input type="text" class="form-control" id="referral_code" name="referral_code">
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Register</button>
                        </form>
                        <div class="text-center mt-3">
                            <a href="login">Already have an account? Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>