<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$db = getDB();

// Get user's investments
$stmt = $db->prepare('SELECT i.*, p.name as plan_name, p.roi FROM investments i JOIN investment_plans p ON i.plan_id = p.id WHERE i.user_id = ? ORDER BY i.start_date DESC');
$stmt->execute([$user['id']]);
$investments = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Investment History - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>My Investment History</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($investments)): ?>
                            <p class="text-center">No investments found.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Plan</th>
                                            <th>Amount</th>
                                            <th>ROI</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Earnings</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($investments as $investment): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($investment['plan_name']); ?></td>
                                            <td>$<?php echo number_format($investment['amount'], 2); ?></td>
                                            <td><?php echo $investment['roi']; ?>%</td>
                                            <td><?php echo date('M d, Y H:i', strtotime($investment['start_date'])); ?></td>
                                            <td><?php echo $investment['end_date'] ? date('M d, Y H:i', strtotime($investment['end_date'])) : 'N/A'; ?></td>
                                            <td class="text-success">+$<?php echo number_format($investment['earnings'], 2); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo $investment['status'] === 'active' ? 'success' : ($investment['status'] === 'completed' ? 'primary' : 'secondary'); ?>">
                                                    <?php echo ucfirst($investment['status']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>