<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$message = '';
$db = getDB();

// Get available wallets
$stmt = $db->query('SELECT * FROM wallets WHERE status = "active" ORDER BY name');
$wallets = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = (float)$_POST['amount'];
    $wallet_type = sanitize($_POST['wallet_type']);
    $tx_hash = sanitize($_POST['tx_hash']);

    if (empty($amount) || empty($wallet_type)) {
        $message = 'Please fill all required fields';
    } else {
        // Insert deposit request
        $stmt = $db->prepare('INSERT INTO deposits (user_id, amount, wallet_type, tx_hash) VALUES (?, ?, ?, ?)');
        if ($stmt->execute([$user['id'], $amount, $wallet_type, $tx_hash])) {
            $message = 'Deposit request submitted successfully! It will be reviewed by our team.';
        } else {
            $message = 'Error submitting deposit request.';
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Make Deposit - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Make a Deposit</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-info"><?php echo $message; ?></div>
                        <?php endif; ?>

                        <div class="alert alert-warning">
                            <strong>Important:</strong> Please ensure you send the exact amount to the selected wallet address. Your deposit will be credited after verification.
                        </div>

                        <form method="post">
                            <div class="form-group">
                                <label>Deposit Amount ($)</label>
                                <input type="number" step="0.01" name="amount" class="form-control" required min="1">
                            </div>

                            <div class="form-group">
                                <label>Select Payment Method</label>
                                <select name="wallet_type" class="form-control" required onchange="showWalletAddress(this.value)">
                                    <option value="">Choose a wallet...</option>
                                    <?php foreach ($wallets as $wallet): ?>
                                        <option value="<?php echo htmlspecialchars($wallet['name']); ?>" data-address="<?php echo htmlspecialchars($wallet['address']); ?>" data-image="<?php echo htmlspecialchars($wallet['image']); ?>">
                                            <?php echo htmlspecialchars($wallet['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div id="wallet-info" style="display: none;" class="form-group">
                                <div class="card">
                                    <div class="card-body">
                                        <h5>Payment Details</h5>
                                        <p><strong>Wallet Address:</strong> <span id="wallet-address"></span></p>
                                        <p><strong>QR Code:</strong> <img id="wallet-qr" src="" alt="QR Code" style="max-width: 200px;"></p>
                                        <p class="text-danger">Send exactly the amount specified above to this address.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Transaction Hash (Optional)</label>
                                <input type="text" name="tx_hash" class="form-control" placeholder="Enter transaction hash after payment">
                                <small class="form-text text-muted">You can add this later in your deposit history if needed.</small>
                            </div>

                            <button type="submit" class="btn btn-primary">Submit Deposit Request</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script>
    function showWalletAddress(walletName) {
        const select = document.querySelector('select[name="wallet_type"]');
        const selectedOption = select.options[select.selectedIndex];
        const address = selectedOption.getAttribute('data-address');
        const image = selectedOption.getAttribute('data-image');

        if (address) {
            document.getElementById('wallet-address').textContent = address;
            document.getElementById('wallet-qr').src = 'user/assets/img/wallets/' + image;
            document.getElementById('wallet-info').style.display = 'block';
        } else {
            document.getElementById('wallet-info').style.display = 'none';
        }
    }
    </script>
</body>
</html>