<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$db = getDB();

// Get user's deposits
$stmt = $db->prepare('SELECT * FROM deposits WHERE user_id = ? ORDER BY date DESC');
$stmt->execute([$user['id']]);
$deposits = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit History - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>My Deposit History</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($deposits)): ?>
                            <p class="text-center">No deposits found.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Wallet Type</th>
                                            <th>TX Hash</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($deposits as $deposit): ?>
                                        <tr>
                                            <td><?php echo date('M d, Y H:i', strtotime($deposit['date'])); ?></td>
                                            <td>$<?php echo number_format($deposit['amount'], 2); ?></td>
                                            <td><?php echo htmlspecialchars($deposit['wallet_type']); ?></td>
                                            <td>
                                                <?php if ($deposit['tx_hash']): ?>
                                                    <span class="text-truncate" style="max-width: 150px;" title="<?php echo htmlspecialchars($deposit['tx_hash']); ?>">
                                                        <?php echo htmlspecialchars(substr($deposit['tx_hash'], 0, 20) . '...'); ?>
                                                    </span>
                                                <?php else: ?>
                                                    <em>Not provided</em>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo $deposit['status'] === 'approved' ? 'success' : ($deposit['status'] === 'rejected' ? 'danger' : 'warning'); ?>">
                                                    <?php echo ucfirst($deposit['status']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>