<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_plan'])) {
        $name = sanitize($_POST['name']);
        $min_amount = (float)$_POST['min_amount'];
        $max_amount = (float)$_POST['max_amount'];
        $roi = (float)$_POST['roi'];
        $duration = (int)$_POST['duration'];

        $stmt = $db->prepare('INSERT INTO investment_plans (name, min_amount, max_amount, roi, duration) VALUES (?, ?, ?, ?, ?)');
        if ($stmt->execute([$name, $min_amount, $max_amount, $roi, $duration])) {
            $message = 'Investment plan added successfully!';
        } else {
            $message = 'Error adding plan.';
        }
    } elseif (isset($_POST['edit_plan'])) {
        $id = (int)$_POST['id'];
        $name = sanitize($_POST['name']);
        $min_amount = (float)$_POST['min_amount'];
        $max_amount = (float)$_POST['max_amount'];
        $roi = (float)$_POST['roi'];
        $duration = (int)$_POST['duration'];
        $status = $_POST['status'];

        $stmt = $db->prepare('UPDATE investment_plans SET name = ?, min_amount = ?, max_amount = ?, roi = ?, duration = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$name, $min_amount, $max_amount, $roi, $duration, $status, $id])) {
            $message = 'Investment plan updated successfully!';
        } else {
            $message = 'Error updating plan.';
        }
    } elseif (isset($_POST['delete_plan'])) {
        $id = (int)$_POST['id'];
        $stmt = $db->prepare('DELETE FROM investment_plans WHERE id = ?');
        if ($stmt->execute([$id])) {
            $message = 'Investment plan deleted successfully!';
        } else {
            $message = 'Error deleting plan.';
        }
    }
}

// Get all plans
$stmt = $db->query('SELECT * FROM investment_plans ORDER BY id DESC');
$plans = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-12">
        <h1>Investment Plans Management</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5>Add New Plan</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Min Amount</label>
                        <input type="number" step="0.01" name="min_amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Max Amount</label>
                        <input type="number" step="0.01" name="max_amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>ROI (%)</label>
                        <input type="number" step="0.01" name="roi" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Duration (hours)</label>
                        <input type="number" name="duration" class="form-control" required>
                    </div>
                    <button type="submit" name="add_plan" class="btn btn-primary">Add Plan</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5>Existing Plans</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Min/Max Amount</th>
                            <th>ROI</th>
                            <th>Duration</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($plans as $plan): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($plan['name']); ?></td>
                            <td>$<?php echo number_format($plan['min_amount'], 2); ?> - $<?php echo number_format($plan['max_amount'], 2); ?></td>
                            <td><?php echo $plan['roi']; ?>%</td>
                            <td><?php echo $plan['duration']; ?> hours</td>
                            <td><?php echo ucfirst($plan['status']); ?></td>
                            <td>
                                <button class="btn btn-sm btn-warning" onclick="editPlan(<?php echo $plan['id']; ?>)">Edit</button>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $plan['id']; ?>">
                                    <button type="submit" name="delete_plan" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Plan</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Min Amount</label>
                        <input type="number" step="0.01" name="min_amount" id="edit_min_amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Max Amount</label>
                        <input type="number" step="0.01" name="max_amount" id="edit_max_amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>ROI (%)</label>
                        <input type="number" step="0.01" name="roi" id="edit_roi" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Duration (hours)</label>
                        <input type="number" name="duration" id="edit_duration" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="edit_plan" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editPlan(id) {
    // Fetch plan data via AJAX or use PHP to populate
    // For simplicity, we'll use a simple approach
    window.location.href = '?edit=' + id;
}
</script>

<?php
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT * FROM investment_plans WHERE id = ?');
    $stmt->execute([$edit_id]);
    $edit_plan = $stmt->fetch();
    if ($edit_plan) {
        echo "<script>
        document.getElementById('edit_id').value = '{$edit_plan['id']}';
        document.getElementById('edit_name').value = '{$edit_plan['name']}';
        document.getElementById('edit_min_amount').value = '{$edit_plan['min_amount']}';
        document.getElementById('edit_max_amount').value = '{$edit_plan['max_amount']}';
        document.getElementById('edit_roi').value = '{$edit_plan['roi']}';
        document.getElementById('edit_duration').value = '{$edit_plan['duration']}';
        document.getElementById('edit_status').value = '{$edit_plan['status']}';
        $('#editModal').modal('show');
        </script>";
    }
}
?>

<?php include 'footer.php'; ?>