<?php
require_once '../auth/config.php';

if (!isAdmin()) {
    redirect('login.php');
}

$admin = getAdmin();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="../auth/user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="../auth/user/assets/css/icons.css" rel="stylesheet">
    <link href="../auth/user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="../auth/user/assets/css/style.css" rel="stylesheet">
    <link href="../auth/user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">Admin Panel</a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="investment-plan.php">Investment Plans</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="withdrawal-history.php">Withdrawals</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="deposit.php">Wallets</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="deposit-history.php">Deposits</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="users.php">Users</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="settings.php">Settings</a>
                    </li>
                </ul>
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown">
                            <?php echo $admin['username']; ?>
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="logout.php">Logout</a>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="container mt-4">