<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle approve/reject
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        $status = 'approved';
        // Update user balance if approving
        $stmt = $db->prepare('SELECT * FROM deposit_history WHERE id = ?');
        $stmt->execute([$id]);
        $deposit = $stmt->fetch();
        if ($deposit) {
            $stmt = $db->prepare('UPDATE users SET balance = balance + ? WHERE id = ?');
            $stmt->execute([$deposit['amount'], $deposit['user_id']]);
        }
    } elseif ($action === 'reject') {
        $status = 'rejected';
    }

    $stmt = $db->prepare('UPDATE deposit_history SET status = ? WHERE id = ?');
    if ($stmt->execute([$status, $id])) {
        $message = 'Deposit ' . $status . ' successfully!';
    } else {
        $message = 'Error updating deposit.';
    }
}

// Get all deposits
$stmt = $db->query('SELECT d.*, u.username, u.email FROM deposit_history d JOIN users u ON d.user_id = u.id ORDER BY d.date DESC');
$deposits = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-12">
        <h1>Deposit History</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>All Deposits</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Amount</th>
                            <th>Wallet Type</th>
                            <th>TX Hash</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($deposits as $deposit): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($deposit['username']); ?> (<?php echo htmlspecialchars($deposit['email']); ?>)</td>
                            <td>$<?php echo number_format($deposit['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($deposit['wallet_type']); ?></td>
                            <td><?php echo htmlspecialchars($deposit['tx_hash'] ?: 'N/A'); ?></td>
                            <td>
                                <span class="badge badge-<?php echo $deposit['status'] === 'approved' ? 'success' : ($deposit['status'] === 'rejected' ? 'danger' : 'warning'); ?>">
                                    <?php echo ucfirst($deposit['status']); ?>
                                </span>
                            </td>
                            <td><?php echo date('Y-m-d H:i', strtotime($deposit['date'])); ?></td>
                            <td>
                                <?php if ($deposit['status'] === 'pending'): ?>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $deposit['id']; ?>">
                                    <input type="hidden" name="action" value="approve">
                                    <button type="submit" class="btn btn-sm btn-success">Approve</button>
                                </form>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $deposit['id']; ?>">
                                    <input type="hidden" name="action" value="reject">
                                    <button type="submit" class="btn btn-sm btn-danger">Reject</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>