<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle approve/reject
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        $status = 'approved';
        // Update user balance if approving
        $stmt = $db->prepare('SELECT * FROM withdrawal_history WHERE id = ?');
        $stmt->execute([$id]);
        $withdrawal = $stmt->fetch();
        if ($withdrawal) {
            $stmt = $db->prepare('UPDATE users SET balance = balance - ? WHERE id = ?');
            $stmt->execute([$withdrawal['amount'], $withdrawal['user_id']]);
        }
    } elseif ($action === 'reject') {
        $status = 'rejected';
    }

    $stmt = $db->prepare('UPDATE withdrawal_history SET status = ? WHERE id = ?');
    if ($stmt->execute([$status, $id])) {
        $message = 'Withdrawal ' . $status . ' successfully!';
    } else {
        $message = 'Error updating withdrawal.';
    }
}

// Get all withdrawals
$stmt = $db->query('SELECT w.*, u.username, u.email FROM withdrawal_history w JOIN users u ON w.user_id = u.id ORDER BY w.date DESC');
$withdrawals = $stmt->fetchAll();
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-money-bill-wave"></i> Withdrawal History</h2>
                <p class="text-muted">Review and manage all withdrawal requests</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Withdrawals Table -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-list"></i> All Withdrawals (<?php echo count($withdrawals); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-user"></i> User</th>
                                <th><i class="fas fa-dollar-sign"></i> Amount</th>
                                <th><i class="fas fa-wallet"></i> Wallet Type</th>
                                <th><i class="fas fa-address-card"></i> Wallet Address</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-calendar"></i> Date</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($withdrawals)): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">
                                    <i class="fas fa-info-circle"></i> No withdrawals found.
                                </td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($withdrawals as $withdrawal): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($withdrawal['username']); ?></strong><br>
                                        <small class="text-muted"><?php echo htmlspecialchars($withdrawal['email']); ?></small>
                                    </td>
                                    <td><strong>$<?php echo number_format($withdrawal['amount'], 2); ?></strong></td>
                                    <td><?php echo htmlspecialchars($withdrawal['wallet_type']); ?></td>
                                    <td>
                                        <span class="text-monospace small"><?php echo htmlspecialchars(substr($withdrawal['wallet_address'], 0, 20)); ?>...</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php
                                            echo $withdrawal['status'] === 'approved' ? 'success' :
                                                 ($withdrawal['status'] === 'rejected' ? 'danger' : 'warning');
                                        ?>">
                                            <?php echo ucfirst($withdrawal['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M d, Y H:i', strtotime($withdrawal['date'])); ?></td>
                                    <td>
                                        <?php if ($withdrawal['status'] === 'pending'): ?>
                                        <form method="post" style="display: inline-block; margin-right: 5px;">
                                            <input type="hidden" name="id" value="<?php echo $withdrawal['id']; ?>">
                                            <input type="hidden" name="action" value="approve">
                                            <button type="submit" class="btn btn-success btn-sm">
                                                <i class="fas fa-check"></i> Approve
                                            </button>
                                        </form>
                                        <form method="post" style="display: inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $withdrawal['id']; ?>">
                                            <input type="hidden" name="action" value="reject">
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-times"></i> Reject
                                            </button>
                                        </form>
                                        <?php else: ?>
                                            <span class="text-muted">No actions</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
