<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_user'])) {
        $id = (int)$_POST['id'];
        $full_name = sanitize($_POST['full_name']);
        $mobile = sanitize($_POST['mobile']);
        $country = sanitize($_POST['country']);
        $status = $_POST['status'];

        $stmt = $db->prepare('UPDATE users SET full_name = ?, mobile = ?, country = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$full_name, $mobile, $country, $status, $id])) {
            $message = 'User updated successfully!';
        } else {
            $message = 'Error updating user.';
        }
    } elseif (isset($_POST['adjust_balance'])) {
        $id = (int)$_POST['id'];
        $amount = (float)$_POST['amount'];
        $action = $_POST['balance_action'];

        if ($action === 'add') {
            $stmt = $db->prepare('UPDATE users SET balance = balance + ? WHERE id = ?');
        } elseif ($action === 'debit') {
            $stmt = $db->prepare('UPDATE users SET balance = balance - ? WHERE id = ?');
        }

        if ($stmt->execute([$amount, $id])) {
            $message = 'Balance adjusted successfully!';
        } else {
            $message = 'Error adjusting balance.';
        }
    }
}

// Get all users
$stmt = $db->query('SELECT * FROM users ORDER BY created_at DESC');
$users = $stmt->fetchAll();
?>

<!-- Page Header -->
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-users"></i> User Management</h2>
                <p class="text-muted">Manage and monitor all platform users</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert Messages -->
<?php if ($message): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success fade-in">
            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Users Table -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-list"></i> All Users (<?php echo count($users); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-user"></i> Username</th>
                                <th><i class="fas fa-envelope"></i> Email</th>
                                <th><i class="fas fa-id-card"></i> Full Name</th>
                                <th><i class="fas fa-dollar-sign"></i> Balance</th>
                                <th><i class="fas fa-circle"></i> Status</th>
                                <th><i class="fas fa-calendar"></i> Joined</th>
                                <th><i class="fas fa-cogs"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($user['username']); ?></td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td><?php echo htmlspecialchars($user['full_name'] ?: 'N/A'); ?></td>
                                <td><strong>$<?php echo number_format($user['balance'], 2); ?></strong></td>
                                <td>
                                    <span class="badge badge-<?php
                                        echo $user['status'] === 'active' ? 'success' :
                                             ($user['status'] === 'inactive' ? 'warning' : 'danger');
                                    ?>">
                                        <?php echo ucfirst($user['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                                <td>
                                    <button class="btn btn-warning btn-sm" onclick="editUser(<?php echo $user['id']; ?>)">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button class="btn btn-info btn-sm" onclick="adjustBalance(<?php echo $user['id']; ?>)">
                                        <i class="fas fa-balance-scale"></i> Balance
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit User Modal -->
<div class="modal" id="editModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit"></i> Edit User</h5>
                <button type="button" class="modal-close" onclick="closeModal('editModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="form-group">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="full_name" id="edit_full_name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Mobile</label>
                        <input type="text" name="mobile" id="edit_mobile" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Country</label>
                        <input type="text" name="country" id="edit_country" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                            <option value="banned">Banned</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Close</button>
                    <button type="submit" name="update_user" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Adjust Balance Modal -->
<div class="modal" id="balanceModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-balance-scale"></i> Adjust Balance</h5>
                <button type="button" class="modal-close" onclick="closeModal('balanceModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <input type="hidden" name="id" id="balance_id">
                    <div class="form-group">
                        <label class="form-label">Amount</label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Action</label>
                        <select name="balance_action" class="form-control">
                            <option value="add">Add to Balance</option>
                            <option value="debit">Debit from Balance</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeModal('balanceModal')">Close</button>
                    <button type="submit" name="adjust_balance" class="btn btn-primary">Adjust Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Modal functions
function openModal(modalId) {
    const modal = document.getElementById(modalId);
    modal.classList.add('show');
}

function closeModal(modalId) {
    const modal = document.getElementById(modalId);
    modal.classList.remove('show');
}

// Close modal when clicking outside
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('modal')) {
        e.target.classList.remove('show');
    }
});

function editUser(id) {
    window.location.href = '?edit=' + id;
}

function adjustBalance(id) {
    document.getElementById('balance_id').value = id;
    openModal('balanceModal');
}

// Handle edit modal on page load
document.addEventListener('DOMContentLoaded', function() {
    <?php if (isset($_GET['edit'])): ?>
        <?php
        $edit_id = (int)$_GET['edit'];
        $stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
        $stmt->execute([$edit_id]);
        $edit_user = $stmt->fetch();
        if ($edit_user):
        ?>
        document.getElementById('edit_id').value = '<?php echo $edit_user['id']; ?>';
        document.getElementById('edit_full_name').value = '<?php echo addslashes($edit_user['full_name']); ?>';
        document.getElementById('edit_mobile').value = '<?php echo addslashes($edit_user['mobile']); ?>';
        document.getElementById('edit_country').value = '<?php echo addslashes($edit_user['country']); ?>';
        document.getElementById('edit_status').value = '<?php echo $edit_user['status']; ?>';
        openModal('editModal');
        <?php endif; ?>
    <?php endif; ?>
});
</script>

<?php include 'footer.php'; ?>
