<?php include 'header.php'; ?>

<!-- Welcome Section -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-body">
                <h2>Welcome back, <?php echo $admin['username']; ?>!</h2>
                <p class="text-muted">Here's what's happening with your platform today.</p>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row">
    <?php
    $db = getDB();

    // Total Users
    $stmt = $db->query('SELECT COUNT(*) as count FROM users');
    $users = $stmt->fetch();
    ?>
    <div class="col-md-3">
        <div class="card stats-card fade-in">
            <div class="stats-icon primary">
                <i class="fas fa-users"></i>
            </div>
            <div class="stats-value"><?php echo number_format($users['count']); ?></div>
            <div class="stats-label">Total Users</div>
        </div>
    </div>

    <?php
    // Total Investments
    $stmt = $db->query('SELECT COUNT(*) as count FROM investments');
    $investments = $stmt->fetch();
    ?>
    <div class="col-md-3">
        <div class="card stats-card fade-in">
            <div class="stats-icon success">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="stats-value"><?php echo number_format($investments['count']); ?></div>
            <div class="stats-label">Total Investments</div>
        </div>
    </div>

    <?php
    // Pending Withdrawals
    $stmt = $db->query('SELECT COUNT(*) as count FROM withdrawals WHERE status = "pending"');
    $withdrawals = $stmt->fetch();
    ?>
    <div class="col-md-3">
        <div class="card stats-card fade-in">
            <div class="stats-icon warning">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stats-value"><?php echo number_format($withdrawals['count']); ?></div>
            <div class="stats-label">Pending Withdrawals</div>
        </div>
    </div>

    <?php
    // Pending Deposits
    $stmt = $db->query('SELECT COUNT(*) as count FROM deposits WHERE status = "pending"');
    $deposits = $stmt->fetch();
    ?>
    <div class="col-md-3">
        <div class="card stats-card fade-in">
            <div class="stats-icon danger">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stats-value"><?php echo number_format($deposits['count']); ?></div>
            <div class="stats-label">Pending Deposits</div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card fade-in">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-bolt"></i> Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2 col-6">
                        <a href="investment-plan.php" class="btn btn-primary">
                            <i class="fas fa-chart-line"></i>
                            Investment Plans
                        </a>
                    </div>
                    <div class="col-md-2 col-6">
                        <a href="withdrawal-history.php" class="btn btn-warning">
                            <i class="fas fa-money-bill-wave"></i>
                            Withdrawals
                        </a>
                    </div>
                    <div class="col-md-2 col-6">
                        <a href="deposit-history.php" class="btn btn-success">
                            <i class="fas fa-history"></i>
                            Deposits
                        </a>
                    </div>
                    <div class="col-md-2 col-6">
                        <a href="users.php" class="btn btn-info">
                            <i class="fas fa-users"></i>
                            Users
                        </a>
                    </div>
                    <div class="col-md-2 col-6">
                        <a href="settings.php" class="btn btn-secondary">
                            <i class="fas fa-cog"></i>
                            Settings
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
