<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$db = getDB();

// Get referral code
$referral_code = $user['referral_code'] ?: generateReferralCode();

// Update user's referral code if not set
if (!$user['referral_code']) {
    $stmt = $db->prepare('UPDATE users SET referral_code = ? WHERE id = ?');
    $stmt->execute([$referral_code, $user['id']]);
}

// Get referred users
$stmt = $db->prepare('SELECT u.username, u.email, r.date, r.bonus FROM referrals r JOIN users u ON r.referred_user_id = u.id WHERE r.user_id = ? ORDER BY r.date DESC');
$stmt->execute([$user['id']]);
$referred_users = $stmt->fetchAll();

// Calculate total referral bonus
$total_bonus = 0;
foreach ($referred_users as $ref) {
    $total_bonus += $ref['bonus'];
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Referral Program - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>My Referral Program</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Your Referral Link</h5>
                                <p>Share this link to earn referral bonuses:</p>
                                <input type="text" class="form-control" value="<?php echo SITE_URL; ?>?ref=<?php echo $referral_code; ?>" readonly onclick="this.select()">
                                <p class="mt-2">Total Referral Bonus: <strong>$<?php echo number_format($total_bonus, 2); ?></strong></p>
                            </div>
                            <div class="col-md-6">
                                <h5>Referral Code</h5>
                                <p>Your unique referral code:</p>
                                <h4 class="text-primary"><?php echo $referral_code; ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>Referred Users</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($referred_users)): ?>
                            <p class="text-center">No referred users yet.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Username</th>
                                            <th>Email</th>
                                            <th>Join Date</th>
                                            <th>Bonus Earned</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($referred_users as $ref): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($ref['username']); ?></td>
                                            <td><?php echo htmlspecialchars($ref['email']); ?></td>
                                            <td><?php echo date('M d, Y', strtotime($ref['date'])); ?></td>
                                            <td class="text-success">+$<?php echo number_format($ref['bonus'], 2); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>