<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$db = getDB();

// Get user's earnings
$stmt = $db->prepare('SELECT * FROM earnings WHERE user_id = ? ORDER BY date DESC');
$stmt->execute([$user['id']]);
$earnings = $stmt->fetchAll();

// Calculate total earnings
$total_earnings = 0;
foreach ($earnings as $earning) {
    $total_earnings += $earning['amount'];
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Earning History - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>My Earning History</h3>
                        <p class="mb-0">Total Earnings: <strong>$<?php echo number_format($total_earnings, 2); ?></strong></p>
                    </div>
                    <div class="card-body">
                        <?php if (empty($earnings)): ?>
                            <p class="text-center">No earnings found.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Source</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($earnings as $earning): ?>
                                        <tr>
                                            <td><?php echo date('M d, Y H:i', strtotime($earning['date'])); ?></td>
                                            <td><?php echo htmlspecialchars($earning['source']); ?></td>
                                            <td class="text-success">+$<?php echo number_format($earning['amount'], 2); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>