
<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();

// Get user statistics
$db = getDB();

// Balance
$balance = $user['balance'];

// Active investments
$stmt = $db->prepare('SELECT COUNT(*) as count FROM investments WHERE user_id = ? AND status = "active"');
$stmt->execute([$user['id']]);
$active_investments = $stmt->fetch()['count'];

// Total deposits
$stmt = $db->prepare('SELECT SUM(amount) as total FROM deposits WHERE user_id = ? AND status = "approved"');
$stmt->execute([$user['id']]);
$total_deposits = $stmt->fetch()['total'] ?: 0;

// Total earnings
$stmt = $db->prepare('SELECT SUM(amount) as total FROM earnings WHERE user_id = ?');
$stmt->execute([$user['id']]);
$total_earnings = $stmt->fetch()['total'] ?: 0;

// Recent deposits
$stmt = $db->prepare('SELECT * FROM deposits WHERE user_id = ? ORDER BY date DESC LIMIT 5');
$stmt->execute([$user['id']]);
$recent_deposits = $stmt->fetchAll();

// Recent withdrawals
$stmt = $db->prepare('SELECT * FROM withdrawals WHERE user_id = ? ORDER BY date DESC LIMIT 5');
$stmt->execute([$user['id']]);
$recent_withdrawals = $stmt->fetchAll();

// Recent earnings
$stmt = $db->prepare('SELECT * FROM earnings WHERE user_id = ? ORDER BY date DESC LIMIT 10');
$stmt->execute([$user['id']]);
$recent_earnings = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>

	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta http-equiv="X-UA-Compatible" content="IE=9">
		<meta name="Description" content="">
		<meta name="Author" content="">
		<meta name="Keywords" content="">
		<title><?php echo SITE_NAME; ?> - Dashboard</title>
		<link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
		<link href="user/assets/css/icons.css" rel="stylesheet">
		<link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
		<link href="user/assets/css/style.css" rel="stylesheet">
		<link href="user/assets/css/animate.css" rel="stylesheet">
		<!---Switcher css-->
		<link href="user/assets/switcher/css/switcher.css" rel="stylesheet">
		<link href="user/assets/switcher/demo.css" rel="stylesheet">
		<script src="https://use.fontawesome.com/fd882038f6.js"></script>
	</head>

	<body class="main-body app sidebar-mini ltr">
		<div class="horizontalMenucontainer">
			<div class="page custom-index">
				<div>
					<div class="main-header side-header sticky nav nav-item" style="margin-bottom: -63px;">
						<div class="container-fluid main-container ">
							<div class="main-header-left ">
								<div class="responsive-logo"> <a href="/" class="header-logo">
										<script data-pagespeed-no-defer="">
											//<![CDATA[
											(function(){for(var g="function"==typeof Object.defineProperties?Object.defineProperty:function(b,c,a){if(a.get||a.set)throw new TypeError("ES3 does not support getters and setters.");b!=Array.prototype&&b!=Object.prototype&&(b[c]=a.value)},h="undefined"!=typeof window&&window===this?this:"undefined"!=typeof global&&null!=global?global:this,k=["String","prototype","repeat"],l=0;l<k.length-1;l++){var m=k[l];m in h||(h[m]={});h=h[m]}var n=k[k.length-1],p=h[n],q=p?p:function(b){var c;if(null==this)throw new TypeError("The 'this' value for String.prototype.repeat must not be null or undefined");c=this+"";if(0>b||1342177279<b)throw new RangeError("Invalid count value");b|=0;for(var a="";b;)if(b&1&&(a+=c),b>>>=1)c+=c;return a};q!=p&&null!=q&&g(h,n,{configurable:!0,writable:!0,value:q});var t=this;function u(b,c){var a=b.split("."),d=t;a[0]in d||!d.execScript||d.execScript("var "+a[0]);for(var e;a.length&&(e=a.shift());)a.length||void 0===c?d[e]?d=d[e]:d=d[e]={}:d[e]=c};function v(b){var c=b.length;if(0<c){for(var a=Array(c),d=0;d<c;d++)a[d]=b[d];return a}return[]};function w(b){var c=window;if(c.addEventListener)c.addEventListener("load",b,!1);else if(c.attachEvent)c.attachEvent("onload",b);else{var a=c.onload;c.onload=function(){b.call(this);a&&a.call(this)}}};var x;function y(b,c,a,d,e){this.h=b;this.j=c;this.l=a;this.f=e;this.g={height:window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight,width:window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth};this.i=d;this.b={};this.a=[];this.c={}}function z(b,c){var a,d,e=c.getAttribute("data-pagespeed-url-hash");if(a=e&&!(e in b.c))if(0>=c.offsetWidth&&0>=c.offsetHeight)a=!1;else{d=c.getBoundingClientRect();var f=document.body;a=d.top+("pageYOffset"in window?window.pageYOffset:(document.documentElement||f.parentNode||f).scrollTop);d=d.left+("pageXOffset"in window?window.pageXOffset:(document.documentElement||f.parentNode||f).scrollLeft);f=a.toString()+","+d;b.b.hasOwnProperty(f)?a=!1:(b.b[f]=!0,a=a<=b.g.height&&d<=b.g.width)}a&&(b.a.push(e),b.c[e]=!0)}y.prototype.checkImageForCriticality=function(b){b.getBoundingClientRect&&z(this,b)};u("pagespeed.CriticalImages.checkImageForCriticality",function(b){x.checkImageForCriticality(b)});u("pagespeed.CriticalImages.checkCriticalImages",function(){A(x)});function A(b){b.b={};for(var c=["IMG","INPUT"],a=[],d=0;d<c.length;++d)a=a.concat(v(document.getElementsByTagName(c[d])));if(a.length&&a[0].getBoundingClientRect){for(d=0;c=a[d];++d)z(b,c);a="oh="+b.l;b.f&&(a+="&n="+b.f);if(c=!!b.a.length)for(a+="&ci="+encodeURIComponent(b.a[0]),d=1;d<b.a.length;++d){var e=","+encodeURIComponent(b.a[d]);131072>=a.length+e.length&&(a+=e)}b.i&&(e="&rd="+encodeURIComponent(JSON.stringify(B())),131072>=a.length+e.length&&(a+=e),c=!0);C=a;if(c){d=b.h;b=b.j;var f;if(window.XMLHttpRequest)f=new XMLHttpRequest;else if(window.ActiveXObject)try{f=new XMLHttpRequest("Msxml2.XMLHTTP")}catch(r){try{f=new XMLHttpRequest("Microsoft.XMLHTTP")}catch(D){}}f&&(f.open("POST",d+(-1==d.indexOf("?")?"?":"&")+"url="+encodeURIComponent(b)),f.setRequestHeader("Content-Type","application/x-www-form-urlencoded"),f.send(a))}}}function B(){var b={},c;c=document.getElementsByTagName("IMG");if(!c.length)return{};var a=c[0];if(!("naturalWidth"in a&&"naturalHeight"in a))return{};for(var d=0;a=c[d];++d){var e=a.getAttribute("data-pagespeed-url-hash");e&&(!(e in b)&&0<a.width&&0<a.height&&0<a.naturalWidth&&0<a.naturalHeight||e in b&&a.width>=b[e].o&&a.height>=b[e].m)&&(b[e]={rw:a.width,rh:a.height,ow:a.naturalWidth,oh:a.naturalHeight})}return b}var C="";u("pagespeed.CriticalImages.getBeaconData",function(){return C});u("pagespeed.CriticalImages.Run",function(b,c,a,d,e,f){var r=new y(b,c,a,e,f);x=r;d&&w(function(){window.setTimeout(function(){A(r)},0)})});})();pagespeed.CriticalImages.Run('/mod_pagespeed_beacon','https://concloudsincs.com/user/secured/index','oG-7lxx8_G',true,false,'c_YDK6KUyW8');
											//]]>
										</script><img src="https://concloudsincs.com/webs/auth/logop.png" class="logo-1" alt="logo" data-pagespeed-url-hash="841475459" onload="pagespeed.CriticalImages.checkImageForCriticality(this);"> <img src="https://concloudsincs.com/webs/auth/logop.png" class="dark-logo-1" alt="logo" width="250px" data-pagespeed-url-hash="841475459" onload="pagespeed.CriticalImages.checkImageForCriticality(this);"> </a> </div>
								<div class="app-sidebar__toggle" data-bs-toggle="sidebar"> <a class="open-toggle" href="javascript:void(0);"><i class="header-icon fe fe-align-left"></i></a> <a class="close-toggle" href="javascript:void(0);"><i class="header-icons fe fe-x"></i></a> </div>
								<div class="main-header-center ms-3 d-sm-none d-md-none d-lg-block"> <input class="form-control" placeholder="Search for anything..." type="search"> <button class="btn"> <i class="fas fa-search d-none d-md-block"></i> </button> </div>
							</div>
							<div class="main-header-right"> <button class="navbar-toggler navresponsive-toggler d-lg-none ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent-4" aria-controls="navbarSupportedContent-4" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon fe fe-more-vertical "></span> </button> <div class="mb-0 navbar navbar-expand-lg navbar-nav-right responsive-navbar navbar-dark p-0">
									<div class="collapse navbar-collapse" id="navbarSupportedContent-4">
										<ul class="nav nav-item  navbar-nav-right ms-auto">
											<li class="dropdown nav-item main-layout"> <a class="new nav-link theme-layout nav-link-bg layout-setting"> <span class="dark-layout"> <svg xmlns="http://www.w3.org/2000/svg" class="header-icon-svgs" width="24" height="24" viewBox="0 0 24 24"> <path d="M20.742 13.045a8.088 8.088 0 0 1-2.077.271c-2.135 0-4.14-.83-5.646-2.336a8.025 8.025 0 0 1-2.064-7.723A1 1 0 0 0 9.73 2.034a10.014 10.014 0 0 0-4.489 2.582c-3.898 3.898-3.898 10.243 0 14.143a9.937 9.937 0 0 0 7.072 2.93 9.93 9.93 0 0 0 7.07-2.929 10.007 10.007 0 0 0 2.583-4.491 1.001 1.001 0 0 0-1.224-1.224zm-2.772 4.301a7.947 7.947 0 0 1-5.656 2.343 7.953 7.953 0 0 1-5.658-2.344c-3.118-3.119-3.118-8.195 0-11.314a7.923 7.923 0 0 1 2.06-1.483 10.027 10.027 0 0 0 2.89 7.848 9.972 9.972 0 0 0 7.848 2.891 8.036 8.036 0 0 1-1.484 2.059z"> </path> </svg> </span> <span class="light-layout"> <svg xmlns="http://www.w3.org/2000/svg" class="header-icon-svgs" width="24" height="24" viewBox="0 0 24 24"> <path d="M6.993 12c0 2.761 2.246 5.007 5.007 5.007s5.007-2.246 5.007-5.007S14.761 6.993 12 6.993 6.993 9.239 6.993 12zM12 8.993c1.658 0 3.007 1.349 3.007 3.007S13.658 15.007 12 15.007 8.993 13.658 8.993 12 10.342 8.993 12 8.993zM10.998 19h2v3h-2zm0-17h2v3h-2zm-9 9h3v2h-3zm17 0h3v2h-3zM4.219 18.363l2.12-2.122 1.415 1.414-2.12 2.122zM16.24 6.344l2.122-2.122 1.414 1.414-2.122 2.122zM6.342 7.759 4.22 5.637l1.415-1.414 2.12 2.122zm13.434 10.605-1.414 1.414-2.122-2.122 1.414-1.414z"> </path> </svg> </span> </a> </li>
											<li class="nav-link search-icon d-lg-none d-block">
												<form class="navbar-form" role="search">
													<div class="input-group"> <input type="text" class="form-control" placeholder="Search"> <span class="input-group-btn"> <button type="reset" class="btn btn-default"> <i class="fas fa-times"></i> </button> <button type="submit" class="btn btn-default nav-link resp-btn"> <svg xmlns="http://www.w3.org/2000/svg" height="24px" class="header-icon-svgs" viewBox="0 0 24 24" width="24px" fill="#000000"> <path d="M0 0h24v24H0V0z" fill="none"></path>
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Total Earned</h5>
                        <h2>$<?php echo number_format($total_earnings, 2); ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Recent Deposits</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($recent_deposits)): ?>
                            <p>No recent deposits found.</p>
                        <?php else: ?>
                            <ul>
                                <?php foreach ($recent_deposits as $deposit): ?>
                                <li><?php echo date('M d, Y', strtotime($deposit['date'])); ?> - $<?php echo number_format($deposit['amount'], 2); ?> (<?php echo htmlspecialchars($deposit['wallet_type']); ?>) - <?php echo ucfirst($deposit['status']); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Recent Withdrawals</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($recent_withdrawals)): ?>
                            <p>No recent withdrawals found.</p>
                        <?php else: ?>
                            <ul>
                                <?php foreach ($recent_withdrawals as $withdrawal): ?>
                                <li><?php echo date('M d, Y', strtotime($withdrawal['date'])); ?> - $<?php echo number_format($withdrawal['amount'], 2); ?> (<?php echo htmlspecialchars($withdrawal['wallet_type']); ?>) - <?php echo ucfirst($withdrawal['status']); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Recent Earnings</h5>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Source</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($recent_earnings)): ?>
                                <tr><td colspan="3">No earnings found.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($recent_earnings as $earning): ?>
                                <tr>
                                    <td><?php echo date('M d, Y', strtotime($earning['date'])); ?></td>
                                    <td><?php echo htmlspecialchars($earning['source']); ?></td>
                                    <td>$<?php echo number_format($earning['amount'], 2); ?></td>
                                </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>