<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_wallet'])) {
        $name = sanitize($_POST['name']);
        $address = sanitize($_POST['address']);
        $image = '';

        // Handle image upload
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../auth/user/assets/img/wallets/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $image_name = time() . '_' . basename($_FILES['image']['name']);
            $image_path = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                $image = 'wallets/' . $image_name;
            }
        }

        $stmt = $db->prepare('INSERT INTO wallets (name, address, image) VALUES (?, ?, ?)');
        if ($stmt->execute([$name, $address, $image])) {
            $message = 'Wallet added successfully!';
        } else {
            $message = 'Error adding wallet.';
        }
    } elseif (isset($_POST['edit_wallet'])) {
        $id = (int)$_POST['id'];
        $name = sanitize($_POST['name']);
        $address = sanitize($_POST['address']);
        $status = $_POST['status'];
        $image = sanitize($_POST['current_image']);

        // Handle image upload
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../auth/user/assets/img/wallets/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $image_name = time() . '_' . basename($_FILES['image']['name']);
            $image_path = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                $image = 'wallets/' . $image_name;
            }
        }

        $stmt = $db->prepare('UPDATE wallets SET name = ?, address = ?, image = ?, status = ? WHERE id = ?');
        if ($stmt->execute([$name, $address, $image, $status, $id])) {
            $message = 'Wallet updated successfully!';
        } else {
            $message = 'Error updating wallet.';
        }
    } elseif (isset($_POST['delete_wallet'])) {
        $id = (int)$_POST['id'];
        $stmt = $db->prepare('DELETE FROM wallets WHERE id = ?');
        if ($stmt->execute([$id])) {
            $message = 'Wallet deleted successfully!';
        } else {
            $message = 'Error deleting wallet.';
        }
    }
}

// Get all wallets
$stmt = $db->query('SELECT * FROM wallets ORDER BY id DESC');
$wallets = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-12">
        <h1>Wallet Management</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5>Add New Wallet</h5>
            </div>
            <div class="card-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <input type="text" name="address" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Image</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    <button type="submit" name="add_wallet" class="btn btn-primary">Add Wallet</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5>Existing Wallets</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($wallets as $wallet): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($wallet['name']); ?></td>
                            <td><?php echo htmlspecialchars($wallet['address']); ?></td>
                            <td>
                                <?php if ($wallet['image']): ?>
                                    <img src="../auth/user/assets/img/<?php echo $wallet['image']; ?>" alt="Wallet" width="50">
                                <?php else: ?>
                                    No image
                                <?php endif; ?>
                            </td>
                            <td><?php echo ucfirst($wallet['status']); ?></td>
                            <td>
                                <button class="btn btn-sm btn-warning" onclick="editWallet(<?php echo $wallet['id']; ?>)">Edit</button>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $wallet['id']; ?>">
                                    <button type="submit" name="delete_wallet" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Wallet</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="post" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <input type="hidden" name="current_image" id="edit_current_image">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <input type="text" name="address" id="edit_address" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Image (leave empty to keep current)</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="edit_wallet" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editWallet(id) {
    window.location.href = '?edit=' + id;
}
</script>

<?php
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT * FROM wallets WHERE id = ?');
    $stmt->execute([$edit_id]);
    $edit_wallet = $stmt->fetch();
    if ($edit_wallet) {
        echo "<script>
        document.getElementById('edit_id').value = '{$edit_wallet['id']}';
        document.getElementById('edit_name').value = '{$edit_wallet['name']}';
        document.getElementById('edit_address').value = '{$edit_wallet['address']}';
        document.getElementById('edit_current_image').value = '{$edit_wallet['image']}';
        document.getElementById('edit_status').value = '{$edit_wallet['status']}';
        $('#editModal').modal('show');
        </script>";
    }
}
?>

<?php include 'footer.php'; ?>