<?php include 'header.php'; ?>

<div class="row">
    <div class="col-md-12">
        <h1>Dashboard</h1>
        <p>Welcome to the admin panel, <?php echo $admin['username']; ?>!</p>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Users</h5>
                <?php
                $db = getDB();
                $stmt = $db->query('SELECT COUNT(*) as count FROM users');
                $users = $stmt->fetch();
                ?>
                <h2><?php echo $users['count']; ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Investments</h5>
                <?php
                $stmt = $db->query('SELECT COUNT(*) as count FROM investments');
                $investments = $stmt->fetch();
                ?>
                <h2><?php echo $investments['count']; ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Pending Withdrawals</h5>
                <?php
                $stmt = $db->query('SELECT COUNT(*) as count FROM withdrawals WHERE status = "pending"');
                $withdrawals = $stmt->fetch();
                ?>
                <h2><?php echo $withdrawals['count']; ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Pending Deposits</h5>
                <?php
                $stmt = $db->query('SELECT COUNT(*) as count FROM deposits WHERE status = "pending"');
                $deposits = $stmt->fetch();
                ?>
                <h2><?php echo $deposits['count']; ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>Quick Actions</h5>
            </div>
            <div class="card-body">
                <a href="investment-plan.php" class="btn btn-primary">Manage Investment Plans</a>
                <a href="withdrawal-history.php" class="btn btn-warning">Review Withdrawals</a>
                <a href="deposit-history.php" class="btn btn-success">Review Deposits</a>
                <a href="users.php" class="btn btn-info">Manage Users</a>
                <a href="settings.php" class="btn btn-secondary">Settings</a>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>