<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$user = getUser();
$db = getDB();

// Get user's withdrawals
$stmt = $db->prepare('SELECT * FROM withdrawal_history WHERE user_id = ? ORDER BY date DESC');
$stmt->execute([$user['id']]);
$withdrawals = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawal History - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="user/assets/css/icons.css" rel="stylesheet">
    <link href="user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="user/assets/css/style.css" rel="stylesheet">
    <link href="user/assets/css/animate.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>My Withdrawal History</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($withdrawals)): ?>
                            <p class="text-center">No withdrawals found.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Wallet Type</th>
                                            <th>Wallet Address</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($withdrawals as $withdrawal): ?>
                                        <tr>
                                            <td><?php echo date('M d, Y H:i', strtotime($withdrawal['date'])); ?></td>
                                            <td>$<?php echo number_format($withdrawal['amount'], 2); ?></td>
                                            <td><?php echo htmlspecialchars($withdrawal['wallet_type']); ?></td>
                                            <td>
                                                <span class="text-truncate" style="max-width: 150px;" title="<?php echo htmlspecialchars($withdrawal['wallet_address']); ?>">
                                                    <?php echo htmlspecialchars(substr($withdrawal['wallet_address'], 0, 20) . '...'); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo $withdrawal['status'] === 'approved' ? 'success' : ($withdrawal['status'] === 'rejected' ? 'danger' : 'warning'); ?>">
                                                    <?php echo ucfirst($withdrawal['status']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>