<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'investment_platform');

// Site configuration
define('SITE_NAME', 'Coins Cloud Limited');
define('SITE_URL', 'http://localhost/auth');
define('ADMIN_EMAIL', 'admin@concloudsincs.com');

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
session_start();

// Database connection
function getDB() {
    static $db = null;
    if ($db === null) {
        try {
            $db = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME, DB_USER, DB_PASS);
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            die('Database connection failed: ' . $e->getMessage());
        }
    }
    return $db;
}

// Utility functions
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function redirect($url) {
    header('Location: ' . $url);
    exit;
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['admin_id']);
}

function getUser($user_id = null) {
    $db = getDB();
    $user_id = $user_id ?: $_SESSION['user_id'];
    $stmt = $db->prepare('SELECT * FROM users WHERE id = ?');
    $stmt->execute([$user_id]);
    return $stmt->fetch();
}

function getAdmin($admin_id = null) {
    $db = getDB();
    $admin_id = $admin_id ?: $_SESSION['admin_id'];
    $stmt = $db->prepare('SELECT * FROM admin WHERE id = ?');
    $stmt->execute([$admin_id]);
    return $stmt->fetch();
}

function getSettings() {
    $db = getDB();
    $stmt = $db->query('SELECT * FROM settings LIMIT 1');
    return $stmt->fetch();
}

// Email functions
function sendEmail($to, $subject, $message) {
    $settings = getSettings();
    if (!$settings) return false;

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: " . $settings['site_name'] . " <" . $settings['site_email'] . ">\r\n";

    return mail($to, $subject, $message, $headers);
}

function generateReferralCode() {
    return strtoupper(substr(md5(uniqid(mt_rand(), true)), 0, 8));
}
?>