<?php
include 'header.php';

$message = '';
$db = getDB();

// Handle approve/reject
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        $status = 'approved';
        // Update user balance if approving
        $stmt = $db->prepare('SELECT * FROM withdrawal_history WHERE id = ?');
        $stmt->execute([$id]);
        $withdrawal = $stmt->fetch();
        if ($withdrawal) {
            $stmt = $db->prepare('UPDATE users SET balance = balance - ? WHERE id = ?');
            $stmt->execute([$withdrawal['amount'], $withdrawal['user_id']]);
        }
    } elseif ($action === 'reject') {
        $status = 'rejected';
    }

    $stmt = $db->prepare('UPDATE withdrawal_history SET status = ? WHERE id = ?');
    if ($stmt->execute([$status, $id])) {
        $message = 'Withdrawal ' . $status . ' successfully!';
    } else {
        $message = 'Error updating withdrawal.';
    }
}

// Get all withdrawals
$stmt = $db->query('SELECT w.*, u.username, u.email FROM withdrawal_history w JOIN users u ON w.user_id = u.id ORDER BY w.date DESC');
$withdrawals = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-12">
        <h1>Withdrawal History</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>All Withdrawals</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Amount</th>
                            <th>Wallet Type</th>
                            <th>Wallet Address</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($withdrawals as $withdrawal): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($withdrawal['username']); ?> (<?php echo htmlspecialchars($withdrawal['email']); ?>)</td>
                            <td>$<?php echo number_format($withdrawal['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($withdrawal['wallet_type']); ?></td>
                            <td><?php echo htmlspecialchars($withdrawal['wallet_address']); ?></td>
                            <td>
                                <span class="badge badge-<?php echo $withdrawal['status'] === 'approved' ? 'success' : ($withdrawal['status'] === 'rejected' ? 'danger' : 'warning'); ?>">
                                    <?php echo ucfirst($withdrawal['status']); ?>
                                </span>
                            </td>
                            <td><?php echo date('Y-m-d H:i', strtotime($withdrawal['date'])); ?></td>
                            <td>
                                <?php if ($withdrawal['status'] === 'pending'): ?>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $withdrawal['id']; ?>">
                                    <input type="hidden" name="action" value="approve">
                                    <button type="submit" class="btn btn-sm btn-success">Approve</button>
                                </form>
                                <form method="post" style="display: inline;">
                                    <input type="hidden" name="id" value="<?php echo $withdrawal['id']; ?>">
                                    <input type="hidden" name="action" value="reject">
                                    <button type="submit" class="btn btn-sm btn-danger">Reject</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>