<?php
include 'header.php';

$message = '';
$db = getDB();

// Get current settings
$stmt = $db->query('SELECT * FROM settings LIMIT 1');
$current_settings = $stmt->fetch();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $smtp_host = sanitize($_POST['smtp_host']);
    $smtp_port = (int)$_POST['smtp_port'];
    $smtp_user = sanitize($_POST['smtp_user']);
    $smtp_pass = $_POST['smtp_pass']; // Don't sanitize password
    $smtp_secure = $_POST['smtp_secure'];
    $site_name = sanitize($_POST['site_name']);
    $site_email = sanitize($_POST['site_email']);

    if ($current_settings) {
        $stmt = $db->prepare('UPDATE settings SET smtp_host = ?, smtp_port = ?, smtp_user = ?, smtp_pass = ?, smtp_secure = ?, site_name = ?, site_email = ? WHERE id = ?');
        $result = $stmt->execute([$smtp_host, $smtp_port, $smtp_user, $smtp_pass, $smtp_secure, $site_name, $site_email, $current_settings['id']]);
    } else {
        $stmt = $db->prepare('INSERT INTO settings (smtp_host, smtp_port, smtp_user, smtp_pass, smtp_secure, site_name, site_email) VALUES (?, ?, ?, ?, ?, ?, ?)');
        $result = $stmt->execute([$smtp_host, $smtp_port, $smtp_user, $smtp_pass, $smtp_secure, $site_name, $site_email]);
    }

    if ($result) {
        $message = 'Settings updated successfully!';
        // Refresh settings
        $stmt = $db->query('SELECT * FROM settings LIMIT 1');
        $current_settings = $stmt->fetch();
    } else {
        $message = 'Error updating settings.';
    }
}
?>

<div class="row">
    <div class="col-md-12">
        <h1>Settings</h1>
        <?php if ($message): ?>
            <div class="alert alert-info"><?php echo $message; ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5>Application Settings</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label>Site Name</label>
                        <input type="text" name="site_name" class="form-control" value="<?php echo htmlspecialchars($current_settings['site_name'] ?? ''); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Site Email</label>
                        <input type="email" name="site_email" class="form-control" value="<?php echo htmlspecialchars($current_settings['site_email'] ?? ''); ?>" required>
                    </div>
                    <h5 class="mt-4">SMTP Settings</h5>
                    <div class="form-group">
                        <label>SMTP Host</label>
                        <input type="text" name="smtp_host" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_host'] ?? ''); ?>" placeholder="smtp.gmail.com">
                    </div>
                    <div class="form-group">
                        <label>SMTP Port</label>
                        <input type="number" name="smtp_port" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_port'] ?? ''); ?>" placeholder="587">
                    </div>
                    <div class="form-group">
                        <label>SMTP Username</label>
                        <input type="text" name="smtp_user" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_user'] ?? ''); ?>" placeholder="your-email@gmail.com">
                    </div>
                    <div class="form-group">
                        <label>SMTP Password</label>
                        <input type="password" name="smtp_pass" class="form-control" value="<?php echo htmlspecialchars($current_settings['smtp_pass'] ?? ''); ?>" placeholder="your-password">
                    </div>
                    <div class="form-group">
                        <label>SMTP Security</label>
                        <select name="smtp_secure" class="form-control">
                            <option value="tls" <?php echo ($current_settings['smtp_secure'] ?? '') === 'tls' ? 'selected' : ''; ?>>TLS</option>
                            <option value="ssl" <?php echo ($current_settings['smtp_secure'] ?? '') === 'ssl' ? 'selected' : ''; ?>>SSL</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Settings</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5>Help</h5>
            </div>
            <div class="card-body">
                <p><strong>Site Name:</strong> The name of your application.</p>
                <p><strong>Site Email:</strong> The email address used for sending notifications.</p>
                <p><strong>SMTP Settings:</strong> Configure these to enable email sending. For Gmail, use smtp.gmail.com, port 587, TLS.</p>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>