<?php
require_once '../auth/config.php';

if (isAdmin()) {
    redirect('dashboard.php');
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $message = 'Please fill all fields';
    } else {
        $db = getDB();
        $stmt = $db->prepare('SELECT * FROM admin WHERE email = ?');
        $stmt->execute([$email]);
        $admin = $stmt->fetch();

        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_id'] = $admin['id'];
            redirect('dashboard.php');
        } else {
            $message = 'Invalid email or password';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?php echo SITE_NAME; ?></title>
    <link rel="icon" href="../auth/user/assets/img/brand/favicon.png" type="image/x-icon">
    <link href="../auth/user/assets/css/icons.css" rel="stylesheet">
    <link href="../auth/user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="../auth/user/assets/css/style.css" rel="stylesheet">
    <link href="../auth/user/assets/css/animate.css" rel="stylesheet">
</head>
<body class="login-page">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="card mt-5">
                    <div class="card-header text-center">
                        <h3>Admin Login</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-danger"><?php echo $message; ?></div>
                        <?php endif; ?>
                        <form method="post">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Login</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="../auth/user/assets/plugins/jquery/jquery.min.js"></script>
    <script src="../auth/user/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>