# Investment Platform

A complete investment and trading platform built with PHP, MySQL, and Bootstrap.

## Features

### User Features
- User registration and login
- Investment plans with different ROI
- Crypto deposits (Bitcoin, Ethereum, USDT)
- Crypto withdrawals
- Investment history
- Earning history
- Profile management
- Referral system
- Email notifications

### Admin Features
- Admin dashboard with statistics
- User management (view, edit, credit/debit balance)
- Investment plan management
- Deposit approval/rejection
- Withdrawal approval/rejection
- Wallet management
- SMTP settings configuration
- Email notifications

## Installation

1. **Clone or download the files** to your web server directory (e.g., `htdocs` or `www`)

2. **Database Setup:**
   - Create a MySQL database named `investment_platform`
   - Import the `auth/database.sql` file to create tables and initial data

3. **Configuration:**
   - Edit `auth/config.php` and update database credentials:
     ```php
     define('DB_HOST', 'localhost');
     define('DB_USER', 'your_db_user');
     define('DB_PASS', 'your_db_password');
     define('DB_NAME', 'investment_platform');
     ```

4. **Web Server Configuration:**
   - Ensure your web server supports PHP and MySQL
   - The `.htaccess` file in the `auth` directory handles URL rewriting to hide `.php` extensions
   - Make sure `mod_rewrite` is enabled in Apache

5. **Email Configuration:**
   - Update SMTP settings in the admin panel (`admin/settings.php`) or directly in the database

## Directory Structure

```
/
├── auth/                    # User-facing pages
│   ├── config.php          # Database and site configuration
│   ├── database.sql        # Database schema
│   ├── .htaccess           # URL rewriting rules
│   ├── index.php           # User dashboard
│   ├── login.php           # User login
│   ├── register.php        # User registration
│   ├── invest.php          # Investment page
│   ├── withdraw.php        # Withdrawal page
│   └── user/               # Static assets (CSS, JS, images)
├── admin/                  # Admin panel
│   ├── index.php           # Admin dashboard
│   ├── login.php           # Admin login
│   ├── approve_deposit.php # Deposit approval
│   └── approve_withdrawal.php # Withdrawal approval
└── README.md              # This file
```

## Default Login Credentials

### Admin
- Username: `admin`
- Password: `password` (hashed in database)

### User
- Create new users through registration or manually in database

## Usage

### For Users:
1. Register at `/auth/register`
2. Login at `/auth/login`
3. Deposit funds using crypto wallets
4. Invest in available plans
5. Monitor earnings and withdraw profits

### For Admins:
1. Login at `/admin/login`
2. Approve/reject deposits and withdrawals
3. Manage users, plans, and wallets
4. Configure SMTP settings

## Security Features

- Password hashing with bcrypt
- Session-based authentication
- Input sanitization
- SQL injection prevention with prepared statements
- XSS protection with htmlspecialchars

## Email Notifications

The system sends emails for:
- User registration welcome
- Password reset
- Deposit approvals
- Withdrawal approvals
- Admin notifications for new deposits/withdrawals

Configure SMTP settings in the admin panel for proper email delivery.

## Investment Logic

- Users can invest in predefined plans
- Investments have duration and ROI
- Earnings are calculated automatically
- Manual approval system for deposits/withdrawals

## API Endpoints

Currently, the system uses direct PHP processing. AJAX calls are used for some dynamic content.

## Browser Support

- Chrome 70+
- Firefox 65+
- Safari 12+
- Edge 79+

## Troubleshooting

1. **404 Errors:** Ensure `.htaccess` is working and `mod_rewrite` is enabled
2. **Database Connection:** Check database credentials in `config.php`
3. **Email Not Sending:** Verify SMTP settings in admin panel
4. **Assets Not Loading:** Check file paths in the `user/` directory

## License

This project is for educational purposes. Use at your own risk.

## Support

For issues or questions, check the code comments or contact the developer.